


=================
**Quiz - 1**





Which UDP port does Network Time Protocol (NTP) primarily use for communication? 

A. 53 
B. 80 
C. 123 
D. 443
















**Correct Answer:** C 
**Reason:** NTP operates over UDP, utilizing port 123 for both source and destination communication.
















=================
**Quiz - 2**








In the context of NTP, what does a "stratum 1" time server represent? 




A. A device that receives time from a stratum 0 source. 
B. A public NTP server accessible via the internet. 
C. A client device synchronizing its time with a local server. 
D. A server that distributes time using an insecure method.













**Correct Answer:** A 
**Reason:** A stratum 1 time server is directly connected to a stratum 0 device, which is an authoritative hardware clock source like a GPS receiver or atomic clock.














=================
**Quiz - 3**







Which of the following is an operation that relies on accurate clock synchronization provided by NTP? 




A. Dynamic Host Configuration Protocol (DHCP) lease renewal. 
B. Spanning Tree Protocol (STP) root bridge election. 
C. Digital certificate validation. 
D. Virtual Local Area Network (VLAN) tagging.














**Correct Answer:** C 
**Reason:** Digital certificates are considered valid only if the current time falls within the time (and date) interval specified inside the certificate, making accurate time synchronization essential.
















=================
**Quiz - 4**






A network administrator wants to establish a highly secure and private NTP service without relying on external internet sources. What would be the most appropriate solution? 



A. Synchronize all devices to public NTP servers with authentication. 
B. Deploy a dedicated NTP server equipped with a GPS receiver. 
C. Designate a pair of internal domain controllers as stratum 2 NTP sources. 
D. Manually configure time on all network devices daily.













**Correct Answer:** B 

**Reason:** A dedicated NTP server with a built-in GPS provides a stratum 1 source that does not require internet access, ensuring a completely private and secure time service.















=================
**Quiz - 5**






When configuring NTP on a Cisco IOS XE device, which command is used to enable NTP authentication? 



A. `ntp enable authentication` 
B. `ntp auth-key-enable` 
C. `ntp authenticate` 
D. `authenticate ntp`













**Correct Answer:** C 
**Reason:** The `ntp authenticate` command is specifically used to enable NTP authentication on Cisco IOS XE devices.













=================
**Quiz - 6**





Which of the following is a valid FIPS-approved algorithm for Hash Message Authentication Code (HMAC) used in NTP authentication? 

A. AES-256 
B. 3DES 
C. SHA-512 
D. MD5















**Correct Answer:** C 
**Reason:** SHA-512 is listed as a NIST-approved HMAC algorithm. AES and 3DES are CMAC algorithms, and MD5 is not listed as a FIPS-approved algorithm in the provided text.













=================
**Quiz - 7**








A network device running NTP receives time from two potential sources: 
Server A (stratum 2) and Server B (stratum 3). Both servers are synchronized. Which server will the device prioritize for time synchronization? 


A. Server A, because it has a lower stratum number. 
B. Server B, because it is further from the authoritative source, indicating stability. 
C. The device will alternate between Server A and Server B to ensure redundancy. 
D. The device will choose based on network latency, regardless of stratum.















**Correct Answer:** A 
**Reason:** A device running NTP automatically chooses as its time source the device with the lowest stratum number that it is configured to communicate with.








=================
**Quiz - 8**







Why is it generally not recommended to use a Cisco Secure Firewall Management Center (FMC) as the primary NTP server for an organization? 



A. FMC lacks the processing power to handle multiple NTP clients. 
B. FMC does not support NTP authentication, making it insecure. 
C. It is better to configure a dedicated, more robust NTP server if possible. 
D. FMC can only synchronize time with Cisco Secure Firewall Threat Defense devices.













**Correct Answer:** C
**Reason:** While FMC can serve as an NTP server in certain scenarios, using it as an NTP server is not recommended and configuring a different NTP server if possible is suggested.










=================
**Quiz - 9**







What is one of the ways NTP avoids synchronizing to a device whose time might be ambiguous? 

A. It only synchronizes with devices that are directly connected to a stratum 0 source. 
B. It never synchronizes to a device that is not synchronized itself. 
C. It requires manual confirmation from an administrator for every synchronization. 
D. It prioritizes devices with the highest stratum number for accuracy.














**Correct Answer:** B 
**Reason:** NTP has a built-in mechanism to avoid ambiguous time sources by never synchronizing to a device that is not synchronized itself












=================
**Quiz - 10**








Which of the following is a primary purpose of logging device and network events? 


A. To reduce network latency. 
B. To facilitate software updates.
C. To provide data for security audits. 
D. To optimize routing table convergence.













**Correct Answer:** C



















=================
**Quiz - 11**






Which severity level on Cisco Secure Firewall ASA is the most urgent?

- critical
    
- errors
    
- warnings
    
- alerts














### Answer

The correct answer is **alerts**. 




Message severities are (from the highest to lowest): emergencies (0), alerts (1), critical (2), errors (3), warnings (4), notifications (5), informational (6), and debugging (7).
















=================
**Quiz - 12**





Which logging destination on Cisco devices is characterized by being low-bandwidth, serial, and typically used for initial device access and basic system messages? 


A. Remote syslog server 
B. Telnet/SSH administrative session 
C. The internal in-memory buffer 
D. Console
















**Correct Answer:** D 
**Reason:** The console is described as a "low-bandwidth serial connection that you can send system log messages to that is inside the console CLI session."



















=================
**Quiz - 13**









When implementing system logging, what is the recommended logging level for regular network operations to avoid excessive data? 




A. Debugging (7) 
B. Informational (6) 
C. Critical (2)
D. Emergencies (0)










**Correct Answer:** B
**Reason:** For regular network operations, the guideline suggests setting the logging level to "Informational" (6) to prevent logging an excessive amount of data.













=================
**Quiz - 14**





Which component of a typical syslog message is described as being disabled by default but can include the interface name, IP address, or hostname? 


A. Timestamp 
B. Message text 
C. Message identifier 
D. Device ID














**Correct Answer:** D 
**Reason:** The device ID is stated to be disabled by default but can include details like interface name, IP address, or hostname.


















=================
**Quiz - 15**








A network administrator is configuring logging on a Cisco Secure Firewall Threat Defense device. By default, which type of events are NOT sent to the Cisco Secure Firewall Management Center? 




A. Snort events 
B. Intrusion events 
C. NAT events 
D. Malware events














**Correct Answer:** C 
**Reason:** By default some events such as NAT events are not logged to Cisco Secure Firewall Management Center, because it records only Snort events and not what happens beforehand."











=================
**Quiz - 16**






What is the primary purpose of Cisco Event Streamer (eStreamer) on a Cisco Secure Firewall Management Center? 

A. To provide a graphical user interface for log analysis. 
B. To stream security events to external client applications. 
C. To perform real-time packet capture for troubleshooting.
D. To automatically generate security policies based on logged data.
















**Correct Answer:** B 
**Reason:** eStreamer allows streaming various Cisco Secure Firewall Management Center events to external client applications, such as Splunk.





















=================
**Quiz - 17**





On a Cisco IOS XE device, which command is used to enable logging to a syslog server and specify the minimum severity level of messages to be sent?
A. logging buffered
B. logging host
C. logging on
D. logging trap










**Correct Answer**: D
**Reason**: The logging trap command is used to enable logging to syslog servers, followed by the required severity level. logging host specifies the server IP, and logging buffered is for the internal buffer.
















=================
**Quiz - 18**







Which of the following is a key guideline for protecting remote logging destinations and stored event data?
A. Ensure all logs are stored on the same server as the network devices.
B. Limit access to the device logging subsystem.
C. Disable logging during peak network traffic to save resources.
D. Use only UDP for syslog transmission to improve performance.














Correct Answer: B
Reason: The guideline states, "Access to the device logging subsystem must be limited (so that attackers or administrators cannot disable logging without detection)."











=================
**Quiz - 19**




Which of the following best describes the primary function of NetFlow?
A. To capture and analyze every packet on the network.
B. To provide a detailed configuration audit of network devices.
C. To characterize network operation by collecting traffic telemetry.
D. To encrypt network traffic for secure communication.












Correct Answer: C
Reason: NetFlow is an embedded feature used to characterize network operation by enabling the collection of network traffic telemetry.









=================
**Quiz - 20**







In standard NetFlow, which of the following is NOT one of the seven key attributes used to define a flow?
A. Source IP address
B. Destination MAC address
C. Layer 3 protocol type
D. Input logical interface












Correct Answer: B
Reason: The seven keys defining a standard NetFlow include source/destination IP address, source/destination port, Layer 3 protocol type, CoS/ToS byte, and input logical interface. Destination MAC address is not listed.










=================
**Quiz - 21**








What is the primary benefit of "flow stitching" at a NetFlow collector?
A. It reduces the overall volume of NetFlow data.
B. It combines related unidirectional flows into a coherent bidirectional flow.
C. It encrypts NetFlow records for secure transmission over the network path.
D. It prioritizes critical application flows over others.
















Correct Answer: **B**

Reason: Flow stitching is a vital technique performed at the NetFlow collector to combine related unidirectional flows into a coherent bidirectional flow, offering a complete view of traffic exchanges.




=================
**Quiz - 22**






Which NetFlow version is characterized by its flexible, template-based export format, allowing for easier support of additional fields and technologies?
A. Version 1
B. Version 5
C. Version 7
D. Version 9



















Correct Answer: D
Reason: NetFlow version 9 is the dominant version today because it provides a flexible and extensible means for carrying NetFlow records, utilizing templates to define record formats.







=================
**Quiz - 23**





Which type of NetFlow implementation on Cisco Secure Firewall ASA is described as a stateful, IP flow tracking method that exports records indicating significant events in a flow?
A. Flexible NetFlow Event Logging (FNEL)
B. Traditional NetFlow Event Logging (TNEL)
C. NetFlow Secure Event Logging (NSEL)
D. Enhanced NetFlow Event Logging (ENEL)
















Correct Answer: C











=================
**Quiz - 24**





A network administrator uses Cisco Secure Network Analytics. What is a key capability of this solution regarding NetFlow data?
A. It only collects NetFlow data from Cisco IOS XE devices.
B. It correlates flows from multiple devices and performs stitching and deduplication.
C. It generates real-time packet captures for detailed analysis.
D. It automatically reconfigures NetFlow on devices based on traffic patterns.














**Correct Answer: B**

Reason: Cisco Secure Network Analytics is noted for its ability to "correlate flows from multiple devices and interfaces and perform stitching and de-duplication action to provide a single bidirectional flow of the traffic end-to-end."







=================
**Quiz - 25**



Which NetFlow verification command on Cisco IOS XE would you use to display the contents (flows) in a specific monitor's cache?
A. show flow exporter statistics
B. show running-config | section flow
C. show flow monitor name <name> cache format table
D. show ip cache flow












Correct Answer: **C**







====================
